/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*
LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : SYNCHRONOUS 4-BIT BINARY COUNTER WITH ASYNCHRONOUS CLEAR 
TRUTHTABLE     : 
+---------------------------------------+-----------------------+
|              INPUTS                   |                       |
+---------------------------------------+       OPERATION       |
|     CLR_     LOAD_ ENT   ENP     CLK  |                       |
+---------------------------------------+-----------------------+
|      L        X     X     X      X    |   ASYNCHRONOUS CLEAR  | 
|                                   _   |                       |
|      H        L     X     X     _/   |   LOAD PARRALLEL DATA |
|                                   _   |                       |
|      H        H     H     H     _/   |   BINARY COUNTER      |
|                                       |                       |
|      H        H     L     X      X    |   INHIBIT COUNTING    |
|                                       |                       |
|      H        H     X     L      X    |   INHIBIT COUNTING    |
+---------------------------------------+-----------------------+

     NOTE : RCO GOES HIGH AT THE TERMINAL COUNT FOR THE DURATION
            OF ONE CLOCK PULSE.
                   
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a161 (clrn, clk, a, b, c, d, enp, ldn, ent, qd, qc, qb, qa, rco);
	parameter size =1;
	input
		clrn,
		clk,
		a,
		b,
		c,
		d,
		enp,
		ldn,
		ent;
	output
		qd,
		qc,
		qb,
		qa,
		rco;
    reg
        NOTIFY_REG;
    not
	  (load, ldn);
    and
	  (enable, clrn, load);
    and
	  (enable1, clrn, ldn);
    not
	M161_inst_I1 (m161_inst_wi1, ldn);
    not
	M161_inst_I2 (m161_inst_wi2, clrn);
    nor
	M161_inst_NO1 (m161_inst_wno1, m161_inst_wna1, m161_inst_wi2);
    nor
	M161_inst_NO2 (m161_inst_wno2, ldn, m161_inst_wi2);
    nor
	M161_inst_NO3 (m161_inst_wno3, m161_inst_wi1, m161_inst_wi2);
    xor
	M161_inst_XOR1 (m161_inst_wxo1, m161_inst_wa1, m161_inst_wno1);
    nand
	M161_inst_NA1 (m161_inst_wna1, ent, enp, ldn);
    and
	M161_inst_A1 (m161_inst_wa1, m161_inst_wno3, m161_inst_qaint);
    and  
	M161_inst_A12 (rco, ent, m161_inst_qaint, m161_inst_qbint, m161_inst_qcint, m161_inst_qdint);
    buf  
	  (qa, m161_inst_qaint);
    buf  
	  (qb, m161_inst_qbint);
    buf  
	  (qc, m161_inst_qcint);
    buf  
	  (qd, m161_inst_qdint);
    U_AO_3
	M161_inst_inst1_inst1 (m161_inst_wo1, m161_inst_wxo1, m161_inst_wno2, a);
    U_AXO_2_2
	M161_inst_inst2_inst1 (m161_inst_wxo2, m161_inst_wno3, m161_inst_qbint, m161_inst_wno1, m161_inst_qaint);
    U_AO_3
	M161_inst_inst3_inst1 (m161_inst_wo2, m161_inst_wxo2, m161_inst_wno2, b);
    U_AXO_2_3
	M161_inst_inst4_inst1 (m161_inst_wxo3, m161_inst_wno3, m161_inst_qcint, m161_inst_wno1, m161_inst_qaint, m161_inst_qbint);
    U_AO_3
	M161_inst_inst5_inst1 (m161_inst_wo3, m161_inst_wxo3, m161_inst_wno2, c);
    U_AXO_2_4
	M161_inst_inst6_inst1 (m161_inst_wxo4, m161_inst_wno3, m161_inst_qdint, m161_inst_wno1, m161_inst_qaint, m161_inst_qbint, m161_inst_qcint);
    U_AO_3
	M161_inst_inst7_inst1 (m161_inst_wo4, m161_inst_wxo4, m161_inst_wno2, d);
    U_FD_P_RB_NO  
	M161_inst_DFF1_inst1 (m161_inst_qaint, m161_inst_wo1, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M161_inst_DFF2_inst1 (m161_inst_qbint, m161_inst_wo2, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M161_inst_DFF3_inst1 (m161_inst_qcint, m161_inst_wo3, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M161_inst_DFF4_inst1 (m161_inst_qdint, m161_inst_wo4, clk, clrn, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
